/*
 * Copyright 2012-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ajoberstar.grgit.operation

import java.util.concurrent.Callable

import org.ajoberstar.grgit.Grgit
import org.ajoberstar.grgit.exception.GrgitException
import org.ajoberstar.grgit.service.RepositoryService

import org.eclipse.jgit.api.Git
import org.eclipse.jgit.api.InitCommand
import org.eclipse.jgit.api.errors.GitAPIException

class InitOp implements Callable<RepositoryService> {
	boolean bare = false
	File dir

	RepositoryService call() {
		InitCommand cmd = Git.init()
		cmd.bare = bare
		cmd.directory = dir
		try {
			cmd.call()
			return Grgit.open(dir)
		} catch (GitAPIException e) {
			throw new GrgitException('Problem initializing repository.', e)
		}
	}
}
