/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.eclipse.jgit.transport.URIish;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;

public class GitPublishReset
extends DefaultTask {
    private final Property<Grgit> grgit;
    private final DirectoryProperty repoDirectory;
    private final Property<String> repoUri;
    private final Property<String> referenceRepoUri;
    private final Property<String> branch;
    private PatternFilterable preserve;

    @Inject
    public GitPublishReset(ProjectLayout layout, ObjectFactory objectFactory) {
        this.grgit = objectFactory.property(Grgit.class);
        this.repoDirectory = this.getProject().getObjects().directoryProperty();
        this.repoUri = objectFactory.property(String.class);
        this.referenceRepoUri = objectFactory.property(String.class);
        this.branch = objectFactory.property(String.class);
        this.getOutputs().upToDateWhen(t -> false);
    }

    @Internal
    public Property<Grgit> getGrgit() {
        return this.grgit;
    }

    @Internal
    public Property<String> getReferenceRepoUri() {
        return this.referenceRepoUri;
    }

    @OutputDirectory
    public DirectoryProperty getRepoDirectory() {
        return this.repoDirectory;
    }

    @Input
    public Property<String> getRepoUri() {
        return this.repoUri;
    }

    @Input
    public Property<String> getBranch() {
        return this.branch;
    }

    @Internal
    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    public void setPreserve(PatternFilterable preserve) {
        this.preserve = preserve;
    }

    @TaskAction
    public void reset() {
        Map remoteBranches;
        boolean remoteBranchExists;
        Map referenceBranches;
        boolean referenceBranchExists;
        Grgit git = this.findExistingRepo().orElseGet(() -> this.freshRepo());
        this.grgit.set((Object)git);
        String pubBranch = (String)this.getBranch().get();
        if (this.referenceRepoUri.isPresent() && (referenceBranchExists = (referenceBranches = git.lsremote(op -> {
            op.setRemote("reference");
            op.setHeads(true);
        })).keySet().stream().anyMatch(ref -> ref.getFullName().equals("refs/heads/" + pubBranch)))) {
            this.getLogger().info("Fetching from reference repo: " + (String)this.referenceRepoUri.get());
            git.fetch(op -> {
                op.setRefSpecs(Arrays.asList(String.format("+refs/heads/%s:refs/remotes/reference/%s", pubBranch, pubBranch)));
                op.setTagMode("none");
            });
        }
        if (remoteBranchExists = (remoteBranches = git.lsremote(op -> {
            op.setRemote("origin");
            op.setHeads(true);
        })).keySet().stream().anyMatch(ref -> ref.getFullName().equals("refs/heads/" + pubBranch))) {
            git.fetch(op -> {
                this.getLogger().info("Fetching from remote repo: " + (String)this.repoUri.get());
                op.setRefSpecs(Arrays.asList(String.format("+refs/heads/%s:refs/remotes/origin/%s", pubBranch, pubBranch)));
                op.setTagMode("none");
            });
            if (!git.getBranch().list().stream().anyMatch(branch -> branch.getName().equals(pubBranch))) {
                git.getBranch().add(op -> {
                    op.setName(pubBranch);
                    op.setStartPoint((Object)("origin/" + pubBranch));
                });
            }
            git.clean(op -> {
                op.setDirectories(true);
                op.setIgnore(false);
            });
            git.checkout(op -> op.setBranch((Object)pubBranch));
            git.reset(op -> {
                op.setCommit((Object)("origin/" + pubBranch));
                op.setMode("hard");
            });
        } else {
            git.checkout(op -> {
                op.setBranch((Object)pubBranch);
                op.setOrphan(true);
            });
        }
        ConfigurableFileTree repoTree = this.getProject().fileTree((Object)git.getRepository().getRootDir());
        FileTree preservedTree = repoTree.matching(this.getPreserve());
        FileTree unwantedTree = repoTree.minus((FileCollection)preservedTree).getAsFileTree();
        unwantedTree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                try {
                    Files.delete(fileVisitDetails.getFile().toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        git.add(op -> {
            op.setPatterns(Stream.of(".").collect(Collectors.toSet()));
            op.setUpdate(true);
        });
    }

    private Optional<Grgit> findExistingRepo() {
        try {
            return Optional.of(Grgit.open(op -> op.setDir((Object)((Directory)this.repoDirectory.get()).getAsFile()))).filter(repo -> {
                boolean valid;
                boolean bl = valid = this.isRemoteUriMatch((Grgit)repo, "origin", (String)this.repoUri.get()) && (!this.referenceRepoUri.isPresent() || this.isRemoteUriMatch((Grgit)repo, "reference", (String)this.referenceRepoUri.get())) && ((String)this.branch.get()).equals(repo.getBranch().current().getName());
                if (!valid) {
                    repo.close();
                }
                return valid;
            });
        }
        catch (Exception e) {
            this.getProject().getLogger().debug("Failed to find existing Git publish repository.", (Throwable)e);
            return Optional.empty();
        }
    }

    private Grgit freshRepo() {
        this.getProject().delete(new Object[]{((Directory)this.repoDirectory.get()).getAsFile()});
        Grgit repo = Grgit.init(op -> op.setDir((Object)((Directory)this.repoDirectory.get()).getAsFile()));
        repo.getRemote().add(op -> {
            op.setName("origin");
            op.setUrl((String)this.repoUri.get());
        });
        if (this.referenceRepoUri.isPresent()) {
            repo.getRemote().add(op -> {
                op.setName("reference");
                op.setUrl((String)this.referenceRepoUri.get());
            });
        }
        return repo;
    }

    private boolean isRemoteUriMatch(Grgit grgit, String remoteName, String remoteUri) {
        try {
            String currentRemoteUri = grgit.getRemote().list().stream().filter(remote -> remote.getName().equals(remoteName)).map(remote -> remote.getUrl()).findAny().orElse(null);
            return new URIish(remoteUri).equals((Object)new URIish(currentRemoteUri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI.", e);
        }
    }
}

