/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish;

import java.util.Optional;
import org.ajoberstar.gradle.git.publish.GitPublishExtension;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishCommit;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishPush;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishReset;
import org.ajoberstar.grgit.Grgit;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;

public class GitPublishPlugin
implements Plugin<Project> {
    static final String RESET_TASK = "gitPublishReset";
    static final String COPY_TASK = "gitPublishCopy";
    static final String COMMIT_TASK = "gitPublishCommit";
    static final String PUSH_TASK = "gitPublishPush";

    public void apply(Project project) {
        GitPublishExtension extension = (GitPublishExtension)project.getExtensions().create("gitPublish", GitPublishExtension.class, new Object[]{project});
        extension.getCommitMessage().set((Object)"Generated by gradle-git-publish.");
        project.getPluginManager().withPlugin("org.ajoberstar.grgit", plugin -> Optional.ofNullable((Grgit)project.findProperty("grgit")).ifPresent(grgit -> {
            extension.getRepoUri().set((Object)this.getOriginUri((Grgit)grgit));
            extension.getReferenceRepoUri().set((Object)grgit.getRepository().getRootDir().toURI().toString());
        }));
        extension.getRepoDir().set(project.getLayout().getBuildDirectory().dir("gitPublish"));
        GitPublishReset reset = this.createResetTask(project, extension);
        Copy copy = this.createCopyTask(project, extension);
        GitPublishCommit commit = this.createCommitTask(project, extension, (Provider<Grgit>)reset.getGrgit());
        GitPublishPush push = this.createPushTask(project, extension, (Provider<Grgit>)reset.getGrgit());
        push.dependsOn(new Object[]{commit});
        commit.dependsOn(new Object[]{copy});
        copy.dependsOn(new Object[]{reset});
        project.getGradle().buildFinished(result -> {
            project.getLogger().info("Closing Git publish repo: {}", extension.getRepoDir().get());
            if (reset.getGrgit().isPresent()) {
                ((Grgit)reset.getGrgit().get()).close();
            }
        });
    }

    private GitPublishReset createResetTask(Project project, GitPublishExtension extension) {
        return (GitPublishReset)project.getTasks().create(RESET_TASK, GitPublishReset.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Prepares a git repo for new content to be generated.");
            task.getRepoDirectory().set((Provider)extension.getRepoDir());
            task.getRepoUri().set(extension.getRepoUri());
            task.getReferenceRepoUri().set(extension.getReferenceRepoUri());
            task.getBranch().set(extension.getBranch());
            task.setPreserve(extension.getPreserve());
        });
    }

    private Copy createCopyTask(Project project, GitPublishExtension extension) {
        return (Copy)project.getTasks().create(COPY_TASK, Copy.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Copy contents to be published to git.");
            task.with(new CopySpec[]{extension.getContents()});
            task.into((Object)extension.getRepoDir());
        });
    }

    private GitPublishCommit createCommitTask(Project project, GitPublishExtension extension, Provider<Grgit> grgitProvider) {
        return (GitPublishCommit)project.getTasks().create(COMMIT_TASK, GitPublishCommit.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Commits changes to be published to git.");
            task.getGrgit().set(grgitProvider);
            task.getMessage().set(extension.getCommitMessage());
        });
    }

    private GitPublishPush createPushTask(Project project, GitPublishExtension extension, Provider<Grgit> grgitProvider) {
        return (GitPublishPush)project.getTasks().create(PUSH_TASK, GitPublishPush.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Pushes changes to git.");
            task.getGrgit().set(grgitProvider);
            task.getBranch().set(extension.getBranch());
        });
    }

    private String getOriginUri(Grgit grgit) {
        return grgit.getRemote().list().stream().filter(remote -> remote.getName().equals("origin")).map(remote -> remote.getUrl()).findAny().orElse(null);
    }
}

