/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;

public class GitPublishReset
extends DefaultTask {
    private final Property<Grgit> grgit;
    private final Property<String> branch;
    private PatternFilterable preserve;

    @Inject
    public GitPublishReset(ObjectFactory objectFactory) {
        this.grgit = objectFactory.property(Grgit.class);
        this.branch = objectFactory.property(String.class);
        this.getOutputs().upToDateWhen(t -> false);
    }

    @Internal
    public Property<Grgit> getGrgit() {
        return this.grgit;
    }

    @Input
    public Property<String> getBranch() {
        return this.branch;
    }

    @Internal
    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    public void setPreserve(PatternFilterable preserve) {
        this.preserve = preserve;
    }

    @OutputDirectory
    public File getRepoDirectory() {
        return ((Grgit)this.getGrgit().get()).getRepository().getRootDir();
    }

    @TaskAction
    public void reset() {
        Grgit git = (Grgit)this.getGrgit().get();
        String pubBranch = (String)this.getBranch().get();
        Map remoteBranches = git.lsremote(op -> {
            op.setRemote("origin");
            op.setHeads(true);
        });
        boolean remoteBranchExists = remoteBranches.keySet().stream().anyMatch(ref -> ref.getFullName().equals("refs/heads/" + pubBranch));
        if (remoteBranchExists) {
            git.fetch(op -> {
                op.setRefSpecs(Arrays.asList(String.format("+refs/heads/%s:refs/remotes/origin/%s", pubBranch, pubBranch)));
                op.setTagMode("none");
            });
            if (!git.getBranch().list().stream().anyMatch(branch -> branch.getName().equals(pubBranch))) {
                git.getBranch().add(op -> {
                    op.setName(pubBranch);
                    op.setStartPoint((Object)("origin/" + pubBranch));
                });
            }
            git.clean(op -> {
                op.setDirectories(true);
                op.setIgnore(false);
            });
            git.checkout(op -> op.setBranch((Object)pubBranch));
            git.reset(op -> {
                op.setCommit((Object)("origin/" + pubBranch));
                op.setMode("hard");
            });
        } else {
            git.checkout(op -> {
                op.setBranch((Object)pubBranch);
                op.setOrphan(true);
            });
        }
        ConfigurableFileTree repoTree = this.getProject().fileTree((Object)git.getRepository().getRootDir());
        FileTree preservedTree = repoTree.matching(this.getPreserve());
        FileTree unwantedTree = repoTree.minus((FileCollection)preservedTree).getAsFileTree();
        unwantedTree.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails fileVisitDetails) {
            }

            public void visitFile(FileVisitDetails fileVisitDetails) {
                try {
                    Files.delete(fileVisitDetails.getFile().toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        git.add(op -> {
            op.setPatterns(Stream.of(".").collect(Collectors.toSet()));
            op.setUpdate(true);
        });
    }
}

