/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish.tasks;

import java.io.File;
import java.util.Arrays;
import javax.inject.Inject;
import org.ajoberstar.grgit.BranchStatus;
import org.ajoberstar.grgit.Grgit;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GitPublishPush
extends DefaultTask {
    private final Property<Grgit> grgit;
    private final Property<String> branch;

    @Inject
    public GitPublishPush(ObjectFactory objectFactory) {
        this.grgit = objectFactory.property(Grgit.class);
        this.branch = objectFactory.property(String.class);
        this.getOutputs().upToDateWhen(t -> false);
        this.onlyIf(t -> {
            try {
                Grgit git = (Grgit)this.getGrgit().get();
                BranchStatus status = git.getBranch().status(op -> op.setName(this.getBranch().get()));
                return status.getAheadCount() > 0;
            }
            catch (IllegalStateException e) {
                return true;
            }
        });
    }

    @Internal
    public Property<Grgit> getGrgit() {
        return this.grgit;
    }

    @Input
    public Property<String> getBranch() {
        return this.branch;
    }

    @OutputDirectory
    public File getRepoDirectory() {
        return ((Grgit)this.getGrgit().get()).getRepository().getRootDir();
    }

    @TaskAction
    public void push() {
        Grgit git = (Grgit)this.getGrgit().get();
        String pubBranch = (String)this.getBranch().get();
        git.push(op -> op.setRefsOrSpecs(Arrays.asList(String.format("refs/heads/%s:refs/heads/%s", pubBranch, pubBranch))));
    }
}

