/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish;

import java.net.URISyntaxException;
import java.util.Optional;
import org.ajoberstar.gradle.git.publish.GitPublishExtension;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishCommit;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishPush;
import org.ajoberstar.gradle.git.publish.tasks.GitPublishReset;
import org.ajoberstar.grgit.Grgit;
import org.eclipse.jgit.transport.URIish;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;

public class GitPublishPlugin
implements Plugin<Project> {
    static final String RESET_TASK = "gitPublishReset";
    static final String COPY_TASK = "gitPublishCopy";
    static final String COMMIT_TASK = "gitPublishCommit";
    static final String PUSH_TASK = "gitPublishPush";

    public void apply(Project project) {
        GitPublishExtension extension = (GitPublishExtension)project.getExtensions().create("gitPublish", GitPublishExtension.class, new Object[]{project});
        extension.getCommitMessage().set((Object)"Publish of Github pages from Gradle.");
        project.getPluginManager().withPlugin("org.ajoberstar.grgit", plugin -> {
            String repoUri = Optional.ofNullable((Grgit)project.findProperty("grgit")).map(this::getOriginUri).orElse(null);
            extension.getRepoUri().set((Object)repoUri);
        });
        extension.getRepoDir().set(project.getLayout().getBuildDirectory().dir("gitPublish"));
        Provider grgitProvider = project.provider(() -> this.findExistingRepo(project, extension).orElseGet(() -> this.freshRepo(project, extension)));
        Task reset = this.createResetTask(project, extension, (Provider<Grgit>)grgitProvider);
        Task copy = this.createCopyTask(project, extension);
        Task commit = this.createCommitTask(project, extension, (Provider<Grgit>)grgitProvider);
        Task push = this.createPushTask(project, extension, (Provider<Grgit>)grgitProvider);
        push.dependsOn(new Object[]{commit});
        commit.dependsOn(new Object[]{copy});
        copy.dependsOn(new Object[]{reset});
        project.getGradle().buildFinished(result -> {
            project.getLogger().info("Closing Git publish repo: {}", extension.getRepoDir().get());
            ((Grgit)grgitProvider.get()).close();
        });
    }

    private Task createResetTask(Project project, GitPublishExtension extension, Provider<Grgit> grgitProvider) {
        return project.getTasks().create(RESET_TASK, GitPublishReset.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Prepares a git repo for new content to be generated.");
            task.getGrgit().set(grgitProvider);
            task.getBranch().set(extension.getBranch());
            task.setPreserve(extension.getPreserve());
        });
    }

    private Task createCopyTask(Project project, GitPublishExtension extension) {
        return project.getTasks().create(COPY_TASK, Copy.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Copy contents to be published to git.");
            task.with(new CopySpec[]{extension.getContents()});
            task.into((Object)extension.getRepoDir());
        });
    }

    private Task createCommitTask(Project project, GitPublishExtension extension, Provider<Grgit> grgitProvider) {
        return project.getTasks().create(COMMIT_TASK, GitPublishCommit.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Commits changes to be published to git.");
            task.getGrgit().set(grgitProvider);
            task.getMessage().set(extension.getCommitMessage());
        });
    }

    private Task createPushTask(Project project, GitPublishExtension extension, Provider<Grgit> grgitProvider) {
        return project.getTasks().create(PUSH_TASK, GitPublishPush.class, task -> {
            task.setGroup("publishing");
            task.setDescription("Pushes changes to git.");
            task.getGrgit().set(grgitProvider);
            task.getBranch().set(extension.getBranch());
        });
    }

    private Optional<Grgit> findExistingRepo(Project project, GitPublishExtension extension) {
        try {
            return Optional.of(Grgit.open(op -> op.setDir((Object)((Directory)extension.getRepoDir().get()).getAsFile()))).filter(repo -> {
                try {
                    boolean valid;
                    String originUri = this.getOriginUri((Grgit)repo);
                    boolean bl = valid = new URIish((String)extension.getRepoUri().get()).equals((Object)new URIish(originUri)) && ((String)extension.getBranch().get()).equals(repo.getBranch().getCurrent().getName());
                    if (!valid) {
                        repo.close();
                    }
                    return valid;
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Invalid URI.", e);
                }
            });
        }
        catch (Exception e) {
            project.getLogger().debug("Failed to find existing Git publish repository.", (Throwable)e);
            return Optional.empty();
        }
    }

    private Grgit freshRepo(Project project, GitPublishExtension extension) {
        project.delete(new Object[]{((Directory)extension.getRepoDir().get()).getAsFile()});
        Grgit repo = Grgit.init(op -> op.setDir((Object)((Directory)extension.getRepoDir().get()).getAsFile()));
        repo.getRemote().add(op -> {
            op.setName("origin");
            op.setUrl((String)extension.getRepoUri().get());
        });
        return repo;
    }

    private String getOriginUri(Grgit grgit) {
        return grgit.getRemote().list().stream().filter(remote -> remote.getName().equals("origin")).map(remote -> remote.getUrl()).findAny().orElse(null);
    }
}

