/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.publish;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public class GitPublishExtension {
    private final DirectoryProperty repoDir;
    private final Property<String> repoUri;
    private final Property<String> branch;
    private final Property<String> commitMessage;
    private final CopySpec contents;
    private final PatternFilterable preserve;

    public GitPublishExtension(Project project) {
        this.repoDir = project.getLayout().directoryProperty();
        this.repoUri = project.getObjects().property(String.class);
        this.branch = project.getObjects().property(String.class);
        this.commitMessage = project.getObjects().property(String.class);
        this.contents = project.copySpec();
        this.preserve = new PatternSet();
        this.preserve.include(new String[]{".git"});
    }

    public DirectoryProperty getRepoDir() {
        return this.repoDir;
    }

    public Property<String> getRepoUri() {
        return this.repoUri;
    }

    public Property<String> getBranch() {
        return this.branch;
    }

    public Property<String> getCommitMessage() {
        return this.commitMessage;
    }

    public CopySpec getContents() {
        return this.contents;
    }

    public void contents(Action<? super CopySpec> action) {
        action.execute((Object)this.contents);
    }

    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    public void preserve(Action<? super PatternFilterable> action) {
        action.execute((Object)this.preserve);
    }
}

