package org.airbloc.ui.utils;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;

public class LiveDataUtils {

    /**
     * Since we cannot use Data Binding, here is a convenient wrapper of {@link LiveData#observe}
     * which calls the observer function just after adding it— thus helps displaying
     * default value in view.
     */
    public static <T> void bind(LifecycleOwner owner, LiveData<T> liveData, Observer<T> observer) {
        liveData.observe(owner, observer);
        observer.onChanged(liveData.getValue());
    }
}
