package org.airbloc.ui.finish;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Transformations;
import android.arch.lifecycle.ViewModelProviders;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import org.airbloc.R;
import org.airbloc.ui.ConsentViewModel;
import org.airbloc.ui.utils.LiveDataUtils;

import static org.airbloc.ui.AirblocUiConstants.AIRBLOC_TRACKER_URL;

public class FinishFragment extends Fragment {
    private ConsentViewModel viewModel;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.fragment_finish, container, false);
        viewModel = ViewModelProviders.of(getActivity()).get(ConsentViewModel.class);

        TextView title = root.findViewById(R.id.org_airbloc__text_finish_title);
        title.setText(Html.fromHtml(String.format(title.getText().toString(),
                getString(R.string.org_airbloc_sdk_consent_app_title))));

        TextView emailText = root.findViewById(R.id.org_airbloc__text_confirm_email);
        LiveDataUtils.bind(this, viewModel.getEmail(), emailText::setText);

        TextView ablAmountText = root.findViewById(R.id.text_abl_amount);

        LiveData<String> ablAmount = Transformations.map(viewModel.getAblAmount(), String::valueOf);
        LiveDataUtils.bind(this, ablAmount, ablAmountText::setText);

        View buttonManageData = root.findViewById(R.id.button_manage_data);
        buttonManageData.setOnClickListener(v -> viewModel.startModifyConsent());

        View buttonLearnMore = root.findViewById(R.id.button_learn_more);
        buttonLearnMore.setOnClickListener(v -> viewModel.openUrl(AIRBLOC_TRACKER_URL));

        View earnMoreAblButton = root.findViewById(R.id.button_earn_more_abl);
        earnMoreAblButton.setOnClickListener(v -> viewModel.goEarnMoreAbl());

        return root;
    }

    /**
     * Called when any finish button is clicked.
     */
    public void onFinishClick(View v) {
        viewModel.finish();
    }
}
