package org.airbloc.ui.consent;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Transformations;
import android.arch.lifecycle.ViewModelProviders;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import org.airbloc.R;
import org.airbloc.sdk.appinfo.AppInfo;
import org.airbloc.ui.ConsentViewModel;
import org.airbloc.ui.utils.LiveDataUtils;

public class AgreementCardFragment extends Fragment {
    private ConsentViewModel viewModel;

    public static AgreementCardFragment newInstance() {
        return new AgreementCardFragment();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        viewModel = ViewModelProviders.of(getActivity()).get(ConsentViewModel.class);
        View root = inflater.inflate(R.layout.card_policy_agreement, container, false);

        AppInfo appInfo = viewModel.getAppInfo();
        int rewardRate = (int) appInfo.getIncentiveRate(AppInfo.THIRD_PARTY_INCENTIVE);

        TextView rewardRateText = root.findViewById(R.id.indicator_third_party_abl_bonus);
        rewardRateText.setText(String.format(getString(R.string.abl_reward_rate), rewardRate));

        bindCheckbox(
                root.findViewById(R.id.check_third_party_agreement),
                viewModel.getThirdPartyAgreement());

        bindCheckbox(
                root.findViewById(R.id.check_service_agreement),
                viewModel.getServiceAgreement());

        View thirdPartyCheck = root.findViewById(R.id.button_third_party_agreement);
        thirdPartyCheck.setOnClickListener(v -> viewModel.toggleThirdPartyAgreement());

        View serviceCheck = root.findViewById(R.id.button_service_agreement);
        serviceCheck.setOnClickListener(v -> viewModel.toggleServiceAgreement());

        // show agreement
        linkifyText(
                root.findViewById(R.id.text_third_party_agreement),
                root.findViewById(R.id.text_service_agreement));

        Button finishButton = root.findViewById(R.id.button_finish_consent);
        finishButton.setOnClickListener(v -> viewModel.finishConsent());

        // button is disabled until user agrees to service agreement
        LiveDataUtils.bind(this, viewModel.getServiceAgreement(), checked -> {
            boolean isChecked = checked == Boolean.TRUE; // nullity
            finishButton.setEnabled(isChecked);
            finishButton.setBackgroundResource(isChecked
                            ? R.drawable.btn_accent
                            : R.drawable.bg_btn_disabled);
        });
        return root;
    }

    private void bindCheckbox(ImageView checkImage, LiveData<Boolean> checkData) {
        Transformations
                .map(checkData, checked -> checked ? R.drawable.ic_agreement_checked : R.drawable.ic_agreement_check_default)
                .observe(this, checkImage::setImageResource);
    }

    private void linkifyText(TextView ...texts) {
        for (TextView text : texts) {
            text.setMovementMethod(LinkMovementMethod.getInstance());
            text.setLinkTextColor(text.getCurrentTextColor());
        }
    }
}
