package org.airbloc.sdk.user;

import android.content.Context;

import org.airbloc.sdk.internal.AirblocExecutors;
import org.airbloc.sdk.internal.AirblocLocalStorage;
import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.networking.AirblocHttpClient;
import org.airbloc.sdk.internal.networking.AirblocHttpRequest;
import org.airbloc.sdk.internal.networking.AirblocHttpResponse;

import java8.util.concurrent.CompletableFuture;

/**
 * Manages user session
 */
public class UserRepositoryImpl implements UserRepository {

    // key in the local storage
    private static final String KEY_SESSION = "user_session";

    private AirblocExecutors executors = AirblocExecutors.getInstance();
    private AirblocHttpClient httpClient;

    private AirblocLocalStorage sessionStorage;

    public UserRepositoryImpl(Context context, AirblocHttpClient httpClient) {
        this.httpClient = httpClient;
        this.sessionStorage = new AirblocLocalStorage(context);
    }

    @Override
    public CompletableFuture<User> get() {
        return CompletableFuture.supplyAsync(() -> {
            JsonData userData = sessionStorage.get(KEY_SESSION);
            if (userData != null) {
                return User.fromJson(userData);
            }
            return null;
        }, executors.getUiExecutor());
    }

    @Override
    public CompletableFuture<User> signUp(String id) {
        AirblocHttpRequest request = new AirblocHttpRequest("POST", "/accounts/signup")
                .setBody(new JsonData().put("email", id));

        return httpClient.call(request)
                .thenApply(AirblocHttpResponse::getBody)
                .thenApply((response) -> {
                    User user = new User(id);
                    user.setAccountId(response.get("account_id"));

                    sessionStorage.put(KEY_SESSION, user);
                    return user;
                });
    }
}
