package org.airbloc.sdk.internal.networking;

import org.airbloc.sdk.internal.JsonData;
import org.json.JSONException;
import org.json.JSONObject;

public class AirblocHttpResponse {
    private int statusCode;
    private String rawBody;
    private JsonData body;

    AirblocHttpResponse(int statusCode, String body) throws AirblocHttpError {
        this.statusCode = statusCode;
        this.body = parseBody(body);
        this.rawBody = body;
    }

    private JsonData parseBody(String rawBody) {
        if (rawBody.isEmpty()) return new JsonData();
        try {
            return JsonData.fromJSON(new JSONObject(rawBody));

        } catch (JSONException error) {
            throw new AirblocHttpError(AirblocHttpError.Reason.InvalidResponse, error.getMessage());
        }
    }

    public int getStatus() {
        return statusCode;
    }

    public String getRawBody() {
        return rawBody;
    }

    public JsonData getBody() {
        return body;
    }

    public boolean isSuccessful() {
        return statusCode >= 200 && statusCode < 400;
    }
}
