package org.airbloc.sdk.internal.networking;

import org.airbloc.sdk.internal.JsonData;

public class AirblocHttpError extends RuntimeException {

    private String detailedMessage;

    public enum Reason {
        RequestFailed,
        NoNetwork,
        InvalidResponse,
        InternalError,
        AuthError,
        InvalidRequest,
        DAuthViolation,
        TransactionFail;

        static Reason fromErrorType(String errorTypeFromServer) {
            switch (errorTypeFromServer) {
                case "authentication_error":
                    return AuthError;
                case "dauth_violated_error":
                    return DAuthViolation;
                case "invalid_request_error":
                    return InvalidRequest;
                case "transaction_error":
                    return TransactionFail;
                default:
                    return InternalError;
            }
        }
    }

    public AirblocHttpError(Reason reason, String detailedMessage) {
        super(reason.name() + ": " + detailedMessage);
        this.detailedMessage = detailedMessage;
    }

    public static AirblocHttpError parse(AirblocHttpResponse response) {
        JsonData body = response.getBody();
        String errorType = body.get("type");
        String errorMessage = body.get("message");

        if (errorType == null || errorMessage == null) {
            // invalid error response; it may came from the front of the WAS
            return new AirblocHttpError(Reason.InternalError, body.toString());
        }
        return new AirblocHttpError(Reason.fromErrorType(errorType), errorMessage);
    }

    public String getDetailedMessage() {
        return detailedMessage;
    }
}
