package org.airbloc.sdk.consent;

import android.content.Context;
import android.content.Intent;

import org.airbloc.sdk.AirblocConfig;
import org.airbloc.sdk.appinfo.DataTypeCategory;
import org.airbloc.sdk.internal.AirblocExecutors;
import org.airbloc.sdk.internal.networking.AirblocHttpClient;
import org.airbloc.sdk.user.UserManager;
import org.airbloc.ui.ConsentActivity;

import java.util.concurrent.TimeUnit;

import java8.util.concurrent.CompletableFuture;

public class ConsentManager {
    private AirblocExecutors executors = AirblocExecutors.getInstance();
    private Consents consentDraft = new Consents();
    private ConsentRepository repository;
    private UserManager currentUser;
    private boolean loaded = false;

    public ConsentManager(
            Context context,
            UserManager userManager,
            AirblocHttpClient httpClient,
            AirblocConfig config) {

        this(userManager, new ConsentRepositoryImpl(context, httpClient, config));
    }

    ConsentManager(UserManager userManager, ConsentRepository repository) {
        this.currentUser = userManager;
        this.repository = repository;
    }

    public ConsentManager consentAll(Consents consents) {
        for (Consents.Consent consent : consents.asList()) {
            consentDraft.consent(consent.categoryId, consent.consented);
        }
        requestUpdate();
        return this;
    }

    public ConsentManager consent(DataTypeCategory category, boolean consent) {
        consentDraft.consent(category.id, consent);
        requestUpdate();
        return this;
    }

    public ConsentManager setAgreement(String type, boolean agreed) {
        consentDraft.setAgreement(type, agreed);
        requestUpdate();
        return this;
    }

    public void launchConsentManager(Context context) {
        Intent intent = new Intent(context, ConsentActivity.class);
        context.startActivity(intent);
    }

    public CompletableFuture<Consents> load() {
        if (!currentUser.hasSignedIn()) {
            return CompletableFuture.completedFuture(null);
        }
        return repository.get(currentUser.getUser()).thenApplyAsync(consents -> {
            loaded = true;
            return consents;
        });
    }

    public boolean isLoaded() {
        return loaded;
    }

    private void requestUpdate() {
        executors.debounce(ConsentManager.class, () -> {
            String accountId = currentUser.getAccountId();
            repository.consent(accountId, consentDraft);

        }, 500, TimeUnit.MILLISECONDS);
    }
}
