package org.airbloc.sdk.appinfo;

import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.JsonMappable;

public class DataTypeCategory implements JsonMappable {
    public int id;
    public String name;
    public String desc;
    public String icon;
    public int rewardAmount;

    public DataTypeCategory(int id, String name, String desc, String icon, int rewardAmount) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.icon = icon;
        this.rewardAmount = rewardAmount;
    }

    public static DataTypeCategory fromJson(JsonData data) {
        return new DataTypeCategory(
                data.getInt("id"),
                data.getString("name"),
                data.getString("description"),
                data.getString("icon"),
                data.getInt("token_reward")
        );
    }

    @Override
    public JsonData toJson() {
        return new JsonData()
                .put("id", id)
                .put("name", name)
                .put("description", desc)
                .put("icon", icon)
                .put("token_reward", rewardAmount);
    }
}
