package org.airbloc.sdk;

import org.airbloc.sdk.datacollector.DataCollector;

class Extensions {

    private DataCollector dataCollector;

    private static final Extensions instance = new Extensions();

    public static Extensions getInstance() {
        return instance;
    }

    public void useDataCollector(DataCollector dataCollector) {
        this.dataCollector = dataCollector;
    }

    public DataCollector getDataCollector() {
        if (dataCollector == null) {
            throw new RuntimeException("Data collector SDK is not configured. " +
                    "Have you tried adding org.airbloc:datacollector to your dependency?");
        }
        return dataCollector;
    }
}
