package org.airbloc.sdk;

import android.content.Context;
import android.content.res.Resources;

import org.airbloc.R;

public class AirblocConfig {
    String appName;
    String appToken;
    String endpoint = SdkConstants.DEFAULT_ENDPOINT;

    AirblocConfig() {}

    static AirblocConfig fromResources(Context context) {
        AirblocConfig config = new AirblocConfig();
        Resources resources = context.getResources();

        String appName = resources.getString(R.string.org_airbloc_sdk_app_name);
        if (!appName.isEmpty()) config.appName = appName;

        String appToken = resources.getString(R.string.org_airbloc_sdk_app_token);
        if (!appToken.isEmpty()) config.appToken = appToken;

        String endpoint = resources.getString(R.string.org_airbloc_sdk_endpoint);
        if (!endpoint.isEmpty()) config.endpoint = endpoint;

        return config;
    }

    void override(AirblocConfig to) {
        if (this.appToken != null) to.appToken = this.appToken;
        if (this.endpoint != null) to.endpoint = this.endpoint;
    }

    public String getAppName() {
        return appName;
    }

    public static class Builder {
        private AirblocConfig config;

        public Builder() {
            config = new AirblocConfig();
        }

        public Builder setAppToken(String appToken) {
            config.appToken = appToken;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            config.endpoint = endpoint;
            return this;
        }

        public AirblocConfig build() {
            return config;
        }
    }
}
