package org.airbloc.ui.finish;

import android.arch.lifecycle.ViewModelProviders;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import org.airbloc.R;
import org.airbloc.ui.ConsentViewModel;

public class SeeOtherAppsFragment extends Fragment {
    private static final String AIRBLOC_TRACKER_LANDING = "https://airbloc.org/#tracker";

    private ConsentViewModel viewModel;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.dialog_consent_all_done, container, false);
        viewModel = ViewModelProviders.of(getActivity()).get(ConsentViewModel.class);

        TextView title = root.findViewById(R.id.org_airbloc__text_alldone_title);
        title.setText(Html.fromHtml(String.format(title.getText().toString(),
                getString(R.string.org_airbloc_sdk_consent_app_title))));

        Button seeOtherButton = root.findViewById(R.id.button_see_other_apps);
        seeOtherButton.setOnClickListener(v -> viewModel.openUrl(AIRBLOC_TRACKER_LANDING));

        return root;
    }
}
