package org.airbloc.sdk.user;

import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.JsonMappable;

public class User implements JsonMappable {

    private String accountId;
    private String externalId;
    private JsonData attributes;

    /**
     * @param id {String} Application-specific unique ID of the user.
     */
    public User(String id) {
        this.attributes = new JsonData();
        this.attributes.put("id", id);
        this.externalId = id;
    }

    public static User fromJson(JsonData json) {
        User user = new User(json.get("external_id"));
        user.accountId = json.get("account_id");
        user.attributes = json.get("attributes");
        return user;
    }

    public <T> void setAttribute(String name, T value) {
        attributes.put(name, value);
    }

    void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getExternalId() {
        return externalId;
    }

    @Override
    public JsonData toJson() {
        return new JsonData()
                .put("external_id", externalId)
                .put("account_id", accountId)
                .put("attributes", attributes);
    }
}
