package org.airbloc.sdk.internal.tasks;

import android.os.Handler;
import android.os.Looper;

import java.util.concurrent.Executor;

public class UiThreadExecutor implements Executor {

    private static UiThreadExecutor instance;

    private Handler handler;

    protected UiThreadExecutor() {
        handler = new Handler(Looper.getMainLooper());
    }

    public static UiThreadExecutor getInstance() {
        if (instance == null) {
            instance = new UiThreadExecutor();
        }
        return instance;
    }

    @Override
    public void execute(Runnable command) {
        handler.post(command);
    }
}
