package org.airbloc.sdk.internal.logger;

import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.JsonMappable;

import java.io.PrintWriter;
import java.io.StringWriter;

class LogEntry implements JsonMappable {

    long at;
    String level;
    String message;
    String stackTrace;

    public static LogEntry fromJson(JsonData json) {
        LogEntry entry = new LogEntry(json.get("level"), json.get("message"));
        entry.at = json.getLong("at");
        if (json.has("stackTrace")) {
            entry.stackTrace = json.getString("stackTrace");
        }
        return entry;
    }

    LogEntry(String level, String message) {
        this.at = System.currentTimeMillis();
        this.level = level;
        this.message = message;
    }

    LogEntry setErrorInfo(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        error.printStackTrace(printer);

        this.stackTrace = stringWriter.toString();
        return this;
    }

    @Override
    public JsonData toJson() {
        return new JsonData()
                .put("at", at)
                .put("level", level)
                .put("message", message)
                .maybePut("stacktrace", stackTrace)
                .toJson();
    }
}
