package org.airbloc.sdk.internal.logger;


import android.util.Log;

import org.airbloc.sdk.SdkConstants;
import org.airbloc.sdk.internal.Functional;
import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.JsonMappable;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * Sends all log to the server when critical error occurred.
 * @author Hyojun Kim
 */
class CrashReporter {
    private List<LogEntry> logs = new LinkedList<>();

    public void record(LogEntry log) {
        try{
            logs.add(log);
        }
        catch (Exception e){
            //만일 로그를 저장하는 중에 오류가 발생하면,
            //해당 로그는 저장을 하거나 서버로 보낼 수 없는 로그일 확률이 큼.
            //OOM 등을 방지하기위해 흘려 보내버림
            AirblocLogger.d("err is occur when record log ");
        }

    }

    public String getFullLogs() {
        StringBuilder fullLog = new StringBuilder();

        for (LogEntry log : logs) {
            if ("verbose".equals(log.level)) continue;

            fullLog.append("[" + log.level + "] ")
                    .append(log.message)
                    .append("\n");
        }
        return fullLog.toString();
    }

    public void reportToServer() {
        try {
            List<JsonData> logEntries = new ArrayList<>();
            for (LogEntry log : logs) {
                logEntries.add(log.toJson());
            }
            // make a request
            JsonData payload = new JsonData()
                    .put("logs", Functional.map(logs, JsonMappable::toJson))
                    .put("logTimestamp", System.currentTimeMillis())
                    .put("sdkVersion", "M_A_" + SdkConstants.VERSION);

            // TODO: send payload
        } catch (Throwable e) {
            Log.e(SdkConstants.LOG_TAG, "Error occurred while sending error logs to server.", e);
            record(new LogEntry("critical", "Error").setErrorInfo(e));
        }
    }
}