package org.airbloc.sdk.event;

import org.airbloc.sdk.internal.JsonData;

public class ContentViewEvent extends Event {

    private static final String DATA_TYPE_NAME = "view-data-0";

    private String contentId;
    private String title;
    private String categoryId;

    public ContentViewEvent(String contentId) {
        this.contentId = contentId;
    }

    public ContentViewEvent setTitle(String title) {
        this.title = title;
        return this;
    }

    public ContentViewEvent setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Override
    public String dataType() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected JsonData payload() {
        return new JsonData()
                .put("contentId", contentId)
                .maybePut("title", title)
                .maybePut("categoryId", categoryId);
    }
}
