package org.airbloc.sdk.datacollector;

import org.airbloc.sdk.event.Event;
import org.airbloc.sdk.user.User;

import java8.util.concurrent.CompletableFuture;

public interface DataCollector<R> {
    <T> CompletableFuture<R> updateUserAttribute(User user, String key, T value);

    CompletableFuture<R> sendEvent(User user, Event event);
}
