package org.airbloc.sdk.appinfo;

import org.airbloc.sdk.internal.Functional;
import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.JsonMappable;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppInfo implements JsonMappable {
    public static final String THIRD_PARTY_INCENTIVE = "third_party";

    public Map<Integer, DataTypeCategory> categories = new HashMap<>();
    public Map<String, Double> incentives = new HashMap<>();

    public AppInfo(List<DataTypeCategory> categories, Map<String, Double> incentives) {
        for (DataTypeCategory category : categories) {
            this.categories.put(category.id, category);
        }
        this.incentives.putAll(incentives);
    }

    public DataTypeCategory getCategoryById(int categoryId) {
        return categories.get(categoryId);
    }

    public double getIncentiveRate(String agreementType) {
        Double incentiveRate = incentives.get(agreementType);
        if (incentiveRate == null) {
            incentiveRate = 1.0;
        }
        return incentiveRate;
    }

    public static AppInfo fromJson(JsonData data) {
        List<JsonData> categoriesData = data.get("categories");
        if (categoriesData == null) {
            categoriesData = Collections.emptyList();
        }
        List<DataTypeCategory> categories = Functional.map(categoriesData, DataTypeCategory::fromJson);

        JsonData incentivesData = data.get("incentives");
        Map<String, Double> incentives = new HashMap<>();
        if (incentivesData != null) {
            incentivesData.copyToMap(incentives);
        }
        return new AppInfo(categories, incentives);
    }

    @Override
    public JsonData toJson() {
        return new JsonData()
                .put("categories", Functional.map(categories.values(), JsonMappable::toJson))
                .put("incentives", incentives);
    }
}
