package org.airbloc.sdk;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

/**
 * A provider for calling {@link Airbloc#configure}.
 * This ContentProvider will automatically injected to application via Manifest Merging.
 */
public class AirblocProvider extends ContentProvider {
    @Override
    public boolean onCreate() {
        // this little hack initializes Airbloc SDK automatically
        try {
            Airbloc.configure(getContext(), null);
            return true;

        } catch (Exception error) {
            Log.e("Airbloc", "Error occurred on initialization", error);
        }
        return false;
    }

    @Override
    public Cursor query(
            @NonNull Uri uri,
            String[] projection,
            @Nullable String selection,
            @Nullable String[] selectionArgs,
            @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}
