package org.airbloc.sdk.event;

import android.support.annotation.NonNull;

import org.airbloc.sdk.internal.JsonData;

public class PurchaseEvent extends Event {

    private static final String DATA_TYPE_NAME = "purchase-data-0";

    private String productId;
    private String currency;
    private String transactionId;
    private Integer value;

    public PurchaseEvent(@NonNull String productId) {
        this.productId = productId;
    }

    public PurchaseEvent(@NonNull String productId, int value) {
        this(productId);
        this.value = value;
    }

    public PurchaseEvent setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public PurchaseEvent setTotalValue(Integer value) {
        this.value = value;
        return this;
    }

    public PurchaseEvent setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @Override
    public String dataType() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected JsonData payload() {
        return new JsonData()
                .put("productId", productId)
                .maybePut("value", value)
                .maybePut("transactionId", transactionId)
                .maybePut("currency", currency);
    }
}
