package org.airbloc.ui.consent;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Transformations;
import android.arch.lifecycle.ViewModelProviders;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import org.airbloc.R;
import org.airbloc.sdk.appinfo.DataTypeCategory;
import org.airbloc.sdk.internal.JsonData;
import org.airbloc.ui.ConsentViewModel;
import org.airbloc.ui.utils.LiveDataUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class DataTypeCardFragment extends Fragment {
    private static final String ARG_CATEGORY = "DATA_TYPE_CATEGORY";

    private ConsentViewModel viewModel;
    private DataTypeCategory dataTypeCategory;

    public static DataTypeCardFragment newInstance(DataTypeCategory dataTypeCategory) {
        Bundle args = new Bundle();
        args.putString(ARG_CATEGORY, dataTypeCategory.toJson().toString());

        DataTypeCardFragment fragment = new DataTypeCardFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = getArguments();
        if (args == null) {
            throw new IllegalArgumentException("No arguments passed.");
        }
        try {
            JSONObject data = new JSONObject(args.getString(ARG_CATEGORY));
            dataTypeCategory = DataTypeCategory.fromJson(JsonData.fromJSON(data));

        } catch (JSONException ignored) {}
        viewModel = ViewModelProviders.of(getActivity()).get(ConsentViewModel.class);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.card_data_type, container, false);
        LiveData<Boolean> consent = viewModel.getConsentOf(dataTypeCategory);

        TextView dataTypeName = view.findViewById(R.id.text_data_type_name);
        dataTypeName.setText(dataTypeCategory.name);

        TextView dataTypeDesc = view.findViewById(R.id.text_data_type_desc);
        dataTypeDesc.setText(dataTypeCategory.desc);

        TextView dataTypeReward = view.findViewById(R.id.text_data_type_reward);
        dataTypeReward.setText(String.valueOf(dataTypeCategory.rewardAmount));

        ImageView dataTypeIcon = view.findViewById(R.id.image_data_type_icon);
        if ("view".equals(dataTypeCategory.icon)) {
            dataTypeIcon.setImageResource(R.drawable.ic_data_type_view);

        } else if ("purchases".equals(dataTypeCategory.icon)) {
            dataTypeIcon.setImageResource(R.drawable.ic_data_type_purchases);
        }

        View toggleButton = view.findViewById(R.id.button_data_type_consent);
        toggleButton.setOnClickListener(v -> viewModel.toggleConsent(dataTypeCategory));

        Transformations.map(consent, consented -> consented
                ? R.drawable.bg_btn_checked
                : R.drawable.bg_btn_blue)
                .observe(this, toggleButton::setBackgroundResource);

        // toggle indicators on consent change
        TextView textConsented = view.findViewById(R.id.text_data_type_consented);
        TextView textNotConsented = view.findViewById(R.id.text_data_type_not_consented);
        TextView indicatorOff = view.findViewById(R.id.indicator_data_type_off);
        TextView indicatorOn = view.findViewById(R.id.indicator_data_type_on);

        LiveDataUtils.bind(this, viewModel.getConsentOf(dataTypeCategory), consented -> {
            if (consented == Boolean.TRUE) {
                textNotConsented.setVisibility(View.GONE);
                textConsented.setVisibility(View.VISIBLE);
                indicatorOff.setVisibility(View.GONE);
                indicatorOn.setVisibility(View.VISIBLE);

            } else {
                textNotConsented.setVisibility(View.VISIBLE);
                textConsented.setVisibility(View.GONE);
                indicatorOff.setVisibility(View.VISIBLE);
                indicatorOn.setVisibility(View.GONE);
            }
        });
        return view;
    }
}
