package org.airbloc.ui;

import android.arch.lifecycle.ViewModelProviders;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.widget.ContentLoadingProgressBar;
import android.view.View;
import android.widget.Toast;

import org.airbloc.R;
import org.airbloc.sdk.internal.logger.AirblocLogger;
import org.airbloc.ui.consent.ConsentFragment;
import org.airbloc.ui.finish.FinishFragment;
import org.airbloc.ui.finish.SeeOtherAppsFragment;
import org.airbloc.ui.intro.IntroFragment;

public class ConsentActivity extends AirblocNavigationActivity {

    private FragmentInfo introFragment = new FragmentInfo(IntroFragment.class, IntroFragment::new);
    private FragmentInfo consentFragment = new FragmentInfo(ConsentFragment.class, ConsentFragment::new);
    private FragmentInfo finishFragment = new FragmentInfo(FinishFragment.class, FinishFragment::new);
    private FragmentInfo seeOtherAppsFragment = new FragmentInfo(SeeOtherAppsFragment.class, SeeOtherAppsFragment::new);

    private ContentLoadingProgressBar progressBar;
    private View backButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_consent);
        ConsentViewModel viewModel = ViewModelProviders.of(this).get(ConsentViewModel.class);

        setupToolbar();

        // show progress bar and hide on intro start
        progressBar = findViewById(R.id.progress_loading);
        if (viewModel.getAppInfo() == null) {
            progressBar.setVisibility(View.VISIBLE);
            progressBar.show();

            viewModel.getLoadFinishEvent().observe(this, err -> {
                if (err != null) {
                    AirblocLogger.wtf("Error occurred on loading", err);
                    Toast.makeText(this, getString(R.string.error_popup), Toast.LENGTH_SHORT).show();
                    finish();
                }
                progressBar.hide();
                progressBar.setVisibility(View.GONE);
            });
        }

        viewModel.getIntroStartEvent().observe(this, v -> navigateTo(introFragment));
        viewModel.getIntroFinishEvent().observe(this, v -> navigateTo(consentFragment));
        viewModel.getConsentFinishEvent().observe(this, v -> navigateTo(finishFragment, true));
        viewModel.getFinishEvent().observe(this, v -> close());
        viewModel.getEarnMoreAblEvent().observe(this, v -> navigateTo(seeOtherAppsFragment));

        viewModel.getOpenUrlEvent().observe(this, url -> {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            startActivity(intent);
        });
    }

    private void setupToolbar() {
        backButton = findViewById(R.id.toolbar_back);
        backButton.setOnClickListener(v -> onBackPressed());

        View closeButton = findViewById(R.id.toolbar_close);
        closeButton.setOnClickListener(v -> close());
    }

    @Override
    protected void setCurrentFragment(FragmentInfo fragment) {
        super.setCurrentFragment(fragment);

        // update back button status
        boolean isBackDisplayed = !isRootFragment() || fragment.name.equals(introFragment.getClass().getName());
        backButton.setVisibility(isBackDisplayed ? View.VISIBLE : View.GONE);
    }

    private void close() {
        // TODO: ask "Are you sure you want to exit?"
        finish();
    }
}
