package org.airbloc.sdk.consent;

import android.util.SparseBooleanArray;

import org.airbloc.sdk.internal.Functional;
import org.airbloc.sdk.internal.JsonData;
import org.airbloc.sdk.internal.JsonMappable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import java8.util.Optional;
import java8.util.stream.StreamSupport;

public class Consents implements JsonMappable {

    private SparseBooleanArray consents = new SparseBooleanArray();
    private Map<String, Boolean> agreements = new HashMap<>();

    public static Consents fromJson(JsonData data) {
         Consents consents = new Consents();

        StreamSupport.stream((List<JsonData>) data.get("categories"))
                 .map(Consent::fromJson)
                 .forEach(c -> consents.consent(c.categoryId, c.consented));

         JsonData agreements = data.get("agreements");
         agreements.copyToMap(consents.agreements);
         return consents;
    }

    public Consents consent(int dataCategoryId, boolean consented) {
        consents.put(dataCategoryId, consented);
        return this;
    }

    public boolean isConsented(int dataCategoryId) {
        return consents.get(dataCategoryId);
    }

    public Consents setAgreement(String type, boolean agreed) {
        agreements.put(type, agreed);
        return this;
    }

    public boolean isAgreed(String type) {
        return Optional.ofNullable(agreements.get(type)).orElse(false);
    }

    public List<Consent> asList() {
        List<Consent> consentList = new ArrayList<>(consents.size());
        for (int i = 0; i < consents.size(); i++) {
            consentList.add(new Consent(consents.keyAt(i), consents.valueAt(i)));
        }
        return consentList;
    }

    @Override
    public JsonData toJson() {
        return new JsonData()
                .put("categories", Functional.map(this.asList(), JsonMappable::toJson))
                .put("agreements", new JsonData(agreements));
    }

    public static class Consent implements JsonMappable {
        public int categoryId;
        public boolean consented;

        public Consent(int categoryId, boolean consented) {
            this.categoryId = categoryId;
            this.consented = consented;
        }

        private static Consent fromJson(JsonData json) {
            return new Consent(json.getInt("id"), json.get("allow"));
        }

        @Override
        public JsonData toJson() {
            return new JsonData()
                .put("id", categoryId)
                .put("allow", consented);
        }
    }
}
