/*
 * Decompiled with CFR 0.152.
 */
package net.ricecode.similarity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.ricecode.similarity.DescendingSimilarityScoreComparator;
import net.ricecode.similarity.SimilarityScore;
import net.ricecode.similarity.SimilarityStrategy;
import net.ricecode.similarity.StringSimilarityService;

public class StringSimilarityServiceImpl
implements StringSimilarityService {
    private final SimilarityStrategy strategy;

    public StringSimilarityServiceImpl(SimilarityStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public List<SimilarityScore> scoreAll(List<String> features, String target) {
        ArrayList<SimilarityScore> scores = new ArrayList<SimilarityScore>();
        for (String feature : features) {
            double score = this.strategy.score(feature, target);
            scores.add(new SimilarityScore(feature, score));
        }
        return scores;
    }

    @Override
    public double score(String feature, String target) {
        return this.strategy.score(feature, target);
    }

    @Override
    public SimilarityScore findTop(List<String> features, String target) {
        return this.findTop(features, target, new DescendingSimilarityScoreComparator());
    }

    @Override
    public SimilarityScore findTop(List<String> features, String target, Comparator<SimilarityScore> comparator) {
        if (features.size() == 0) {
            return null;
        }
        List<SimilarityScore> scores = this.scoreAll(features, target);
        Collections.sort(scores, comparator);
        return scores.get(0);
    }

    @Override
    public List<SimilarityScore> findBestN(List<String> features, String target, int n) {
        List<SimilarityScore> result = new ArrayList<SimilarityScore>();
        if (features.size() > 0 && n >= 1) {
            List<SimilarityScore> scores = this.scoreAll(features, target);
            Collections.sort(scores, new DescendingSimilarityScoreComparator());
            result = scores.subList(0, Math.min(scores.size(), n));
        }
        return result;
    }
}

