/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.io.PrintStream;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ShutdownSignalBarrier
implements AutoCloseable {
    private static final SignalHandler NO_OP_SIGNAL_HANDLER = () -> {};
    private static final CopyOnWriteArrayList<ShutdownSignalBarrier> BARRIERS = new CopyOnWriteArrayList();
    private static final Thread SIGNAL_ALL_SHUTDOWN_HOOK = new Thread(() -> {
        Object[] barriers = ShutdownSignalBarrier.signalAndClearAll();
        ShutdownSignalBarrier.awaitTermination(barriers, 10, TimeUnit.SECONDS, System.out);
    }, "ShutdownSignalBarrier");
    final CountDownLatch waitLatch = new CountDownLatch(1);
    final CountDownLatch closeLatch = new CountDownLatch(1);
    final AtomicBoolean signaled = new AtomicBoolean();
    private final SignalHandler signalHandler;

    public ShutdownSignalBarrier() {
        this(NO_OP_SIGNAL_HANDLER);
    }

    public ShutdownSignalBarrier(SignalHandler signalHandler) {
        this.signalHandler = Objects.requireNonNull(signalHandler);
        BARRIERS.add(this);
    }

    public void signal() {
        if (this.signaled.compareAndSet(false, true)) {
            BARRIERS.remove(this);
            this.waitLatch.countDown();
            this.signalHandler.onSignal();
        }
    }

    public void signalAll() {
        ShutdownSignalBarrier.signalAndClearAll();
    }

    public void remove() {
        BARRIERS.remove(this);
    }

    public void await() {
        try {
            this.waitLatch.await();
        }
        catch (InterruptedException ignore) {
            try {
                this.signal();
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        try {
            this.signal();
        }
        finally {
            this.closeLatch.countDown();
        }
    }

    public String toString() {
        return "ShutdownSignalBarrier{waitLatch=" + String.valueOf(this.waitLatch) + ", closeLatch=" + String.valueOf(this.closeLatch) + ", signaled=" + String.valueOf(this.signaled) + "}";
    }

    private static Object[] signalAndClearAll() {
        Object[] barriers = BARRIERS.toArray();
        BARRIERS.clear();
        RuntimeException exception = null;
        for (Object barrier : barriers) {
            try {
                ((ShutdownSignalBarrier)barrier).signal();
            }
            catch (RuntimeException ex) {
                if (null == exception) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (null != exception) {
            throw exception;
        }
        return barriers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void awaitTermination(Object[] barriers, int timeout, TimeUnit timeUnit, PrintStream out) {
        boolean wasInterruped = false;
        try {
            int completed = 0;
            block5: do {
                for (int i = 0; i < barriers.length; ++i) {
                    Object barrier = barriers[i];
                    if (null == barrier) continue;
                    try {
                        if (((ShutdownSignalBarrier)barrier).closeLatch.await(timeout, timeUnit)) {
                            ++completed;
                            barriers[i] = null;
                            continue;
                        }
                        out.println("WARN: ShutdownSignalBarrier hasn't terminated in " + timeUnit.toSeconds(timeout) + " seconds! Did you forget to call `close()` on it?");
                        continue;
                    }
                    catch (InterruptedException e) {
                        wasInterruped = true;
                        continue block5;
                    }
                }
            } while (completed < barriers.length);
        }
        finally {
            if (wasInterruped) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(SIGNAL_ALL_SHUTDOWN_HOOK);
    }

    @FunctionalInterface
    public static interface SignalHandler {
        public void onSignal();
    }
}

