/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.util.concurrent.atomic.AtomicLong;
import org.agrona.concurrent.status.Position;

public class AtomicLongPosition
extends Position {
    private boolean isClosed = false;
    private final int id;
    private final AtomicLong value;

    public AtomicLongPosition() {
        this(0, 0L);
    }

    public AtomicLongPosition(int id) {
        this(id, 0L);
    }

    public AtomicLongPosition(int id, long initialValue) {
        this.id = id;
        this.value = new AtomicLong(initialValue);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long get() {
        return this.value.getPlain();
    }

    @Override
    public long getVolatile() {
        return this.value.get();
    }

    @Override
    public long getAcquire() {
        return this.value.getAcquire();
    }

    @Override
    public long getOpaque() {
        return this.value.getOpaque();
    }

    @Override
    public void set(long value) {
        this.value.setPlain(value);
    }

    @Override
    public void setOpaque(long value) {
        this.value.setOpaque(value);
    }

    @Override
    public void setOrdered(long value) {
        this.setRelease(value);
    }

    @Override
    public void setRelease(long value) {
        this.value.setRelease(value);
    }

    @Override
    public void setVolatile(long value) {
        this.value.set(value);
    }

    @Override
    public boolean proposeMax(long proposedValue) {
        return this.proposeMaxRelease(proposedValue);
    }

    @Override
    public boolean proposeMaxOrdered(long proposedValue) {
        return this.proposeMaxRelease(proposedValue);
    }

    @Override
    public boolean proposeMaxRelease(long proposedValue) {
        boolean updated = false;
        if (this.value.get() < proposedValue) {
            this.value.setRelease(proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean proposeMaxOpaque(long proposedValue) {
        boolean updated = false;
        if (this.value.get() < proposedValue) {
            this.value.setOpaque(proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public String toString() {
        return "AtomicLongPosition{isClosed=" + this.isClosed() + ", id=" + this.id + ", value=" + String.valueOf(this.isClosed() ? Integer.valueOf(-1) : this.value) + "}";
    }
}

