/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.agrona.concurrent.BackoffIdleStrategyData;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.hints.ThreadHints;

public final class BackoffIdleStrategy
extends BackoffIdleStrategyData
implements IdleStrategy {
    public static final long DEFAULT_MAX_SPINS = 10L;
    public static final long DEFAULT_MAX_YIELDS = 5L;
    public static final long DEFAULT_MIN_PARK_PERIOD_NS = 1000L;
    public static final long DEFAULT_MAX_PARK_PERIOD_NS = 1000000L;
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    long p8;

    public BackoffIdleStrategy() {
        super(10L, 5L, 1000L, 1000000L);
    }

    public BackoffIdleStrategy(long maxSpins, long maxYields, long minParkPeriodNs, long maxParkPeriodNs) {
        super(maxSpins, maxYields, minParkPeriodNs, maxParkPeriodNs);
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            this.reset();
        } else {
            this.idle();
        }
    }

    @Override
    public void idle() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                ++this.spins;
                break;
            }
            case 1: {
                ThreadHints.onSpinWait();
                if (++this.spins <= this.maxSpins) break;
                this.state = 2;
                this.yields = 0L;
                break;
            }
            case 2: {
                if (++this.yields > this.maxYields) {
                    this.state = 3;
                    this.parkPeriodNs = this.minParkPeriodNs;
                    break;
                }
                Thread.yield();
                break;
            }
            case 3: {
                LockSupport.parkNanos(this.parkPeriodNs);
                this.parkPeriodNs = Math.min(this.parkPeriodNs << 1, this.maxParkPeriodNs);
            }
        }
    }

    @Override
    public void reset() {
        this.spins = 0L;
        this.yields = 0L;
        this.parkPeriodNs = this.minParkPeriodNs;
        this.state = 0;
    }

    public String toString() {
        return "BackoffIdleStrategy{maxSpins=" + this.maxSpins + ", maxYields=" + this.maxYields + ", minParkPeriodNs=" + this.minParkPeriodNs + ", maxParkPeriodNs=" + this.maxParkPeriodNs + '}';
    }
}

