/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.agent;

import org.agrona.DirectBuffer;
import org.agrona.agent.BufferAlignmentException;
import org.agrona.shadow.net.bytebuddy.asm.Advice;

public class BufferAlignmentInterceptor {

    public static final class CharVerifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 1L)) {
                throw new BufferAlignmentException("Unaligned char access", index, buffer.addressOffset());
            }
        }
    }

    public static final class ShortVerifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 1L)) {
                throw new BufferAlignmentException("Unaligned short access", index, buffer.addressOffset());
            }
        }
    }

    public static final class FloatVerifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 3L)) {
                throw new BufferAlignmentException("Unaligned float access", index, buffer.addressOffset());
            }
        }
    }

    public static final class IntVerifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 3L)) {
                throw new BufferAlignmentException("Unaligned int access", index, buffer.addressOffset());
            }
        }
    }

    public static final class DoubleVerifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 7L)) {
                throw new BufferAlignmentException("Unaligned double access", index, buffer.addressOffset());
            }
        }
    }

    public static final class LongVerifier {
        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 7L)) {
                throw new BufferAlignmentException("Unaligned long access", index, buffer.addressOffset());
            }
        }
    }
}

