/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Objects;
import org.agrona.LangUtil;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SigInt {
    public static void register(Runnable task) {
        SigInt.register("INT", task);
    }

    static void register(String signalName, Runnable task) {
        Objects.requireNonNull(task);
        Signal namedSignal = new Signal(signalName);
        SignalHandler previousHandler = Signal.handle(namedSignal, signal -> {});
        Signal.handle(namedSignal, signal -> {
            Throwable error = null;
            try {
                task.run();
            }
            catch (Throwable t) {
                error = t;
            }
            if (null != previousHandler) {
                try {
                    previousHandler.handle(signal);
                }
                catch (Throwable t) {
                    if (null != error) {
                        error.addSuppressed(t);
                    }
                    error = t;
                }
            }
            LangUtil.rethrowUnchecked(error);
        });
    }
}

