/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.agrona.generation.DynamicPackageOutputManger;

public class StringWriterOutputManager
implements DynamicPackageOutputManger {
    private String packageName;
    private String initialPackageName;
    private final HashMap<String, StringWriter> sourceFileByName = new HashMap();

    @Override
    public Writer createOutput(String name) {
        StringWriter stringWriter = new StringWriter();
        this.sourceFileByName.put(this.packageName + "." + name, stringWriter);
        return new FilterWriter(stringWriter){

            @Override
            public void close() throws IOException {
                super.close();
                if (null != StringWriterOutputManager.this.initialPackageName) {
                    StringWriterOutputManager.this.packageName = StringWriterOutputManager.this.initialPackageName;
                }
            }
        };
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
        if (null == this.initialPackageName) {
            this.initialPackageName = packageName;
        }
    }

    public CharSequence getSource(String name) {
        StringWriter stringWriter = this.sourceFileByName.get(name);
        if (null == stringWriter) {
            throw new IllegalArgumentException("unknown source file name: " + name);
        }
        return stringWriter.toString();
    }

    public Map<String, CharSequence> getSources() {
        HashMap<String, CharSequence> sources = new HashMap<String, CharSequence>();
        for (Map.Entry<String, StringWriter> entry : this.sourceFileByName.entrySet()) {
            sources.put(entry.getKey(), entry.getValue().toString());
        }
        return sources;
    }

    public void clear() {
        this.initialPackageName = null;
        this.packageName = "";
        this.sourceFileByName.clear();
    }
}

