/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;

public class UnsafeBufferPosition
implements Position {
    private final int counterId;
    private final long addressOffset;
    private final byte[] buffer;
    private final CountersManager countersManager;

    public UnsafeBufferPosition(UnsafeBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public UnsafeBufferPosition(UnsafeBuffer buffer, int counterId, CountersManager countersManager) {
        this.counterId = counterId;
        this.countersManager = countersManager;
        this.buffer = buffer.byteArray();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public long get() {
        return UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.buffer, this.addressOffset);
    }

    @Override
    public void set(long value) {
        UnsafeAccess.UNSAFE.putLong(this.buffer, this.addressOffset, value);
    }

    @Override
    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.buffer, this.addressOffset, value);
    }

    @Override
    public boolean proposeMax(long proposedValue) {
        boolean updated = false;
        if (UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset) < proposedValue) {
            UnsafeAccess.UNSAFE.putLong(this.buffer, this.addressOffset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean proposeMaxOrdered(long proposedValue) {
        boolean updated = false;
        if (UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset) < proposedValue) {
            UnsafeAccess.UNSAFE.putOrderedLong(this.buffer, this.addressOffset, proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public void close() {
        if (null != this.countersManager) {
            this.countersManager.free(this.counterId);
        }
    }
}

