/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentRunner
implements Runnable,
AutoCloseable {
    private static final Thread TOMBSTONE = new Thread();
    private volatile boolean running = true;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final IdleStrategy idleStrategy;
    private final Agent agent;
    private final AtomicReference<Thread> thread = new AtomicReference();

    public AgentRunner(IdleStrategy idleStrategy, ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(idleStrategy, "idleStrategy");
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public static void startOnThread(AgentRunner runner) {
        Thread thread = new Thread(runner);
        thread.setName(runner.agent().roleName());
        thread.start();
    }

    public Agent agent() {
        return this.agent;
    }

    @Override
    public void run() {
        if (!this.thread.compareAndSet(null, Thread.currentThread())) {
            return;
        }
        IdleStrategy idleStrategy = this.idleStrategy;
        Agent agent = this.agent;
        while (this.running) {
            try {
                idleStrategy.idle(agent.doWork());
            }
            catch (InterruptedException ignore) {
                Thread.interrupted();
            }
            catch (ClosedByInterruptException ignore) {
            }
            catch (Throwable ex) {
                if (null != this.errorCounter) {
                    this.errorCounter.increment();
                }
                this.errorHandler.onError(ex);
            }
        }
    }

    @Override
    public final void close() {
        this.running = false;
        Thread thread = this.thread.getAndSet(TOMBSTONE);
        if (TOMBSTONE != thread) {
            if (null != thread) {
                try {
                    while (true) {
                        thread.join(1000L);
                        if (thread.isAlive()) {
                            System.err.println("timeout await for agent. Retrying...");
                            thread.interrupt();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.agent.onClose();
        }
    }
}

