/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.BitUtil;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AbstractConcurrentArrayQueueConsumer;
import org.agrona.concurrent.AbstractConcurrentArrayQueuePadding3;
import org.agrona.concurrent.AbstractConcurrentArrayQueueProducer;
import org.agrona.concurrent.QueuedPipe;

public abstract class AbstractConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueuePadding3
implements QueuedPipe<E> {
    protected static final long TAIL_OFFSET;
    protected static final long SHARED_HEAD_CACHE_OFFSET;
    protected static final long HEAD_OFFSET;
    protected static final int BUFFER_ARRAY_BASE;
    protected static final int SHIFT_FOR_SCALE;
    protected final int capacity;
    protected final E[] buffer;

    public AbstractConcurrentArrayQueue(int requestedCapacity) {
        this.capacity = BitUtil.findNextPositivePowerOfTwo(requestedCapacity);
        this.buffer = new Object[this.capacity];
    }

    @Override
    public long addedCount() {
        return this.tail;
    }

    @Override
    public long removedCount() {
        return this.head;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity() - this.size();
    }

    @Override
    public E peek() {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, AbstractConcurrentArrayQueue.sequenceToBufferOffset(this.head, this.capacity - 1));
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full");
    }

    @Override
    public E remove() {
        Object e = this.poll();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (null == e) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public boolean contains(Object o) {
        if (null == o) {
            return false;
        }
        E[] buffer = this.buffer;
        int mask = this.capacity - 1;
        long limit = this.tail;
        for (long i = this.head; i < limit; ++i) {
            Object e = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, AbstractConcurrentArrayQueue.sequenceToBufferOffset(i, mask));
            if (!o.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        Object value;
        while (null != (value = this.poll())) {
        }
    }

    @Override
    public int size() {
        long currentTail;
        long currentHeadBefore;
        long currentHeadAfter = this.head;
        do {
            currentHeadBefore = currentHeadAfter;
            currentTail = this.tail;
        } while ((currentHeadAfter = this.head) != currentHeadBefore);
        return (int)(currentTail - currentHeadAfter);
    }

    public static long sequenceToBufferOffset(long sequence, long mask) {
        return (long)BUFFER_ARRAY_BASE + ((sequence & mask) << SHIFT_FOR_SCALE);
    }

    static {
        try {
            BUFFER_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
            SHIFT_FOR_SCALE = BitUtil.calculateShiftForScale(UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class));
            TAIL_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(AbstractConcurrentArrayQueueProducer.class.getDeclaredField("tail"));
            SHARED_HEAD_CACHE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(AbstractConcurrentArrayQueueProducer.class.getDeclaredField("sharedHeadCache"));
            HEAD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(AbstractConcurrentArrayQueueConsumer.class.getDeclaredField("head"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

