/*
 * Decompiled with CFR 0.152.
 */
package org.agorava.twitter.model;

import java.util.Date;

public class RateLimitStatus {
    private final int hourlyLimit;
    private final int remainingHits;
    private final long resetTimeInSeconds;
    private final Date resetTime;

    public RateLimitStatus(int hourlyLimit, int remainingHits, long resetTimeInSeconds) {
        this.hourlyLimit = hourlyLimit;
        this.remainingHits = remainingHits;
        this.resetTimeInSeconds = resetTimeInSeconds;
        this.resetTime = new Date(resetTimeInSeconds * 1000L);
    }

    public int getHourlyLimit() {
        return this.hourlyLimit;
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public long getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public int getSecondsUntilReset() {
        return (int)(this.resetTimeInSeconds - System.currentTimeMillis() / 1000L);
    }
}

