/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aeonbits.owner.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Util {
    static TimeProvider timeProvider = new TimeProvider(){

        public long getTime() {
            return System.currentTimeMillis();
        }
    };
    static SystemProvider system = new SystemProvider(){

        @Override
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public Map<String, String> getenv() {
            return System.getenv();
        }

        @Override
        public Properties getProperties() {
            return System.getProperties();
        }
    };

    private Util() {
    }

    static <T> List<T> reverse(List<T> src) {
        ArrayList<T> copy = new ArrayList<T>(src);
        Collections.reverse(copy);
        return copy;
    }

    static <T> T[] reverse(T[] array) {
        Object[] copy = (Object[])array.clone();
        Collections.reverse(Arrays.asList(copy));
        return copy;
    }

    static String expandUserHome(String text) {
        if (text.equals("~")) {
            return system.getProperty("user.home");
        }
        if (text.indexOf("~/") == 0 || text.indexOf("file:~/") == 0 || text.indexOf("jar:file:~/") == 0) {
            return text.replaceFirst("~/", Util.fixBackslashForRegex(system.getProperty("user.home")) + "/");
        }
        if (text.indexOf("~\\") == 0 || text.indexOf("file:~\\") == 0 || text.indexOf("jar:file:~\\") == 0) {
            return text.replaceFirst("~\\\\", Util.fixBackslashForRegex(system.getProperty("user.home")) + "\\\\");
        }
        return text;
    }

    static String fixBackslashForRegex(String text) {
        return text.replace("\\", "\\\\");
    }

    static <T> T ignore() {
        return null;
    }

    static boolean isFeatureDisabled(Method method, Config.DisableableFeature feature) {
        Class<Config.DisableFeature> annotation = Config.DisableFeature.class;
        return Util.isFeatureDisabled(feature, method.getDeclaringClass().getAnnotation(annotation)) || Util.isFeatureDisabled(feature, method.getAnnotation(annotation));
    }

    private static boolean isFeatureDisabled(Config.DisableableFeature feature, Config.DisableFeature annotation) {
        return annotation != null && Arrays.asList(annotation.value()).contains((Object)feature);
    }

    static UnsupportedOperationException unsupported(Throwable cause, String msg, Object ... args) {
        return new UnsupportedOperationException(String.format(msg, args), cause);
    }

    static UnsupportedOperationException unsupported(String msg, Object ... args) {
        return new UnsupportedOperationException(String.format(msg, args));
    }

    static <T> T unreachableButCompilerNeedsThis() {
        throw new AssertionError((Object)"this code should never be reached");
    }

    static String asString(Object result) {
        if (result == null) {
            return null;
        }
        return String.valueOf(result);
    }

    static long now() {
        return timeProvider.getTime();
    }

    static File fileFromURL(URL url) {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            String path = url.getPath();
            try {
                path = URLDecoder.decode(path, "utf-8");
                return new File(path);
            }
            catch (UnsupportedEncodingException e) {
                return (File)Util.unreachableButCompilerNeedsThis();
            }
        }
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            String path = url.getPath();
            try {
                return Util.fileFromURL(path.substring(0, path.indexOf(33)));
            }
            catch (MalformedURLException e) {
                return (File)Util.ignore();
            }
        }
        return null;
    }

    static File fileFromURL(String urlSpec) throws MalformedURLException {
        return Util.fileFromURL(new URL(urlSpec));
    }

    static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    static SystemProvider system() {
        return system;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface SystemProvider {
        public String getProperty(String var1);

        public Map<String, String> getenv();

        public Properties getProperties();
    }

    static interface TimeProvider {
        public long getTime();
    }
}

