/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.PropertiesManager;
import org.aeonbits.owner.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HotReloadLogic
implements Serializable {
    private final PropertiesManager manager;
    private final long interval;
    private final Config.HotReloadType type;
    private volatile long lastCheckTime = Util.now();
    private final List<WatchableFile> watchableFiles = new ArrayList<WatchableFile>();

    public HotReloadLogic(Config.HotReload hotReload, List<URL> urls, PropertiesManager manager) {
        this.manager = manager;
        this.type = hotReload.type();
        this.interval = hotReload.unit().toMillis(hotReload.value());
        this.setupWatchableResources(urls);
    }

    private void setupWatchableResources(List<URL> urls) {
        for (URL url : urls) {
            File file = Util.fileFromURL(url);
            if (file == null) continue;
            this.watchableFiles.add(new WatchableFile(file));
        }
    }

    synchronized void checkAndReload() {
        if (this.needsReload()) {
            this.manager.reload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsReload() {
        if (this.manager.isLoading()) {
            return false;
        }
        long now = Util.now();
        if (now < this.lastCheckTime + this.interval) {
            return false;
        }
        try {
            for (WatchableFile resource : this.watchableFiles) {
                if (!resource.isChanged()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastCheckTime = now;
        }
    }

    boolean isAsync() {
        return this.type == Config.HotReloadType.ASYNC;
    }

    boolean isSync() {
        return this.type == Config.HotReloadType.SYNC;
    }

    private static class WatchableFile
    implements Serializable {
        private final File file;
        private long lastModifiedTime;

        WatchableFile(File file) {
            this.file = file;
            this.lastModifiedTime = file.lastModified();
        }

        public boolean isChanged() {
            boolean changed;
            long lastModifiedTimeNow = this.file.lastModified();
            boolean bl = changed = this.lastModifiedTime != lastModifiedTimeNow;
            if (changed) {
                this.lastModifiedTime = lastModifiedTimeNow;
            }
            return changed;
        }
    }
}

