/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.types.VariableType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ProcessExtensionService {
    private String processExtensionsRoot;
    private String processExtensionsSuffix;
    private final ObjectMapper objectMapper;
    private ResourcePatternResolver resourceLoader;
    private Map<String, VariableType> variableTypeMap;
    private Map<String, ProcessExtensionModel> processExtensionModelMap;
    private Map<String, String> procDefIdToKey = new ConcurrentHashMap<String, String>();
    private static final ProcessExtensionModel EMPTY_EXTENSIONS = new ProcessExtensionModel();
    private RepositoryService repositoryService;

    public ProcessExtensionService(String processExtensionsRoot, String processExtensionsSuffix, ObjectMapper objectMapper, ResourcePatternResolver resourceLoader, Map<String, VariableType> variableTypeMap) {
        this.processExtensionsRoot = processExtensionsRoot;
        this.processExtensionsSuffix = processExtensionsSuffix;
        this.objectMapper = objectMapper;
        this.resourceLoader = resourceLoader;
        this.variableTypeMap = variableTypeMap;
    }

    private Optional<Resource[]> retrieveResources() throws IOException {
        Optional<Resource[]> resources = Optional.empty();
        Resource processExtensionsResource = this.resourceLoader.getResource(this.processExtensionsRoot);
        if (processExtensionsResource.exists()) {
            return Optional.ofNullable(this.resourceLoader.getResources(this.processExtensionsRoot + this.processExtensionsSuffix));
        }
        return resources;
    }

    private ProcessExtensionModel read(InputStream inputStream) throws IOException {
        this.objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        ProcessExtensionModel mappedModel = (ProcessExtensionModel)this.objectMapper.readValue(inputStream, ProcessExtensionModel.class);
        return this.convertJsonVariables(mappedModel);
    }

    private ProcessExtensionModel convertJsonVariables(ProcessExtensionModel processExtensionModel) {
        if (processExtensionModel != null && processExtensionModel.getExtensions() != null && processExtensionModel.getExtensions().getProperties() != null) {
            for (VariableDefinition variableDefinition : processExtensionModel.getExtensions().getProperties().values()) {
                if (this.variableTypeMap.keySet().contains(variableDefinition.getType()) && !variableDefinition.getType().equals("json")) continue;
                variableDefinition.setValue(this.objectMapper.convertValue(variableDefinition.getValue(), JsonNode.class));
            }
        }
        return processExtensionModel;
    }

    public Map<String, ProcessExtensionModel> readProcessExtensions() throws IOException {
        ArrayList<ProcessExtensionModel> processExtensionModels = new ArrayList<ProcessExtensionModel>();
        Optional<Resource[]> resourcesOptional = this.retrieveResources();
        if (resourcesOptional.isPresent()) {
            for (Resource resource : resourcesOptional.get()) {
                processExtensionModels.add(this.read(resource.getInputStream()));
            }
        }
        this.processExtensionModelMap = this.convertToMap(processExtensionModels);
        return this.processExtensionModelMap;
    }

    public void cache(ProcessDefinition processDefinition) {
        this.procDefIdToKey.put(processDefinition.getId(), processDefinition.getKey());
    }

    public boolean hasExtensionsFor(ProcessDefinition processDefinition) {
        return this.hasExtensionsFor(processDefinition.getKey());
    }

    public boolean hasExtensionsFor(String processDefinitionKey) {
        return this.processExtensionModelMap.containsKey(processDefinitionKey);
    }

    public ProcessExtensionModel getExtensionsFor(ProcessDefinition processDefinition) {
        return this.getProcessExtensionModelForKey(processDefinition.getKey());
    }

    private ProcessExtensionModel getProcessExtensionModelForKey(String processDefinitionKey) {
        ProcessExtensionModel processExtensionModel = this.processExtensionModelMap.get(processDefinitionKey);
        return processExtensionModel != null ? processExtensionModel : EMPTY_EXTENSIONS;
    }

    public ProcessExtensionModel getExtensionsForId(String processDefinitionId) {
        return this.getProcessExtensionModelForKey(this.procDefIdToKey.getOrDefault(processDefinitionId, this.getProcessDefinionKey(processDefinitionId)));
    }

    private String getProcessDefinionKey(String processDefinitionId) {
        return Optional.ofNullable(this.repositoryService.getProcessDefinition(processDefinitionId)).map(it -> it.getKey()).orElse(null);
    }

    private Map<String, ProcessExtensionModel> convertToMap(List<ProcessExtensionModel> processExtensionModelList) {
        return processExtensionModelList.stream().collect(Collectors.toMap(ProcessExtensionModel::getId, Function.identity()));
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

