/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class ExecutionListenerValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        this.validateListeners(process, (BaseElement)process, process.getExecutionListeners(), errors);
        for (FlowElement flowElement : process.getFlowElements()) {
            this.validateListeners(process, (BaseElement)flowElement, flowElement.getExecutionListeners(), errors);
        }
    }

    protected void validateListeners(Process process, BaseElement baseElement, List<ActivitiListener> listeners, List<ValidationError> errors) {
        if (listeners != null) {
            for (ActivitiListener listener : listeners) {
                if (listener.getImplementation() == null || listener.getImplementationType() == null) {
                    this.addError(errors, "activiti-execution-listener-implementation-missing", process, baseElement, "Element 'class' or 'expression' is mandatory on executionListener");
                }
                if (listener.getOnTransaction() == null || !ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) continue;
                this.addError(errors, "activiti-execution-listener-invalid-implementation-type", process, baseElement, "Expression cannot be used when using 'onTransaction'");
            }
        }
    }
}

