/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class EventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List events = process.findFlowElementsOfType(Event.class);
        for (Event event : events) {
            if (event.getEventDefinitions() == null) continue;
            for (EventDefinition eventDefinition : event.getEventDefinitions()) {
                if (eventDefinition instanceof MessageEventDefinition) {
                    this.handleMessageEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof SignalEventDefinition) {
                    this.handleSignalEventDefinition(bpmnModel, process, event, eventDefinition, errors);
                    continue;
                }
                if (eventDefinition instanceof TimerEventDefinition) {
                    this.handleTimerEventDefinition(process, event, eventDefinition, errors);
                    continue;
                }
                if (!(eventDefinition instanceof CompensateEventDefinition)) continue;
                this.handleCompensationEventDefinition(bpmnModel, process, event, eventDefinition, errors);
            }
        }
    }

    protected void handleMessageEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)messageEventDefinition.getMessageRef())) {
            this.addError(errors, "activiti-message-event-missing-message-ref", process, (BaseElement)event, "attribute 'messageRef' is required");
        } else if (!bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
            this.addError(errors, "activiti-message-event-invalid-message-ref", process, (BaseElement)event, "Invalid 'messageRef': no message with that id can be found in the model");
        }
    }

    protected void handleSignalEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)signalEventDefinition.getSignalRef())) {
            this.addError(errors, "activiti-signal-event-missing-signal-ref", process, (BaseElement)event, "signalEventDefinition does not have mandatory property 'signalRef'");
        } else if (!bpmnModel.containsSignalId(signalEventDefinition.getSignalRef())) {
            this.addError(errors, "activiti-signal-event-invalid-signal-ref", process, (BaseElement)event, "Invalid 'signalRef': no signal with that id can be found in the model");
        }
    }

    protected void handleTimerEventDefinition(Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
        if (StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeDate()) && StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeCycle()) && StringUtils.isEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            this.addError(errors, "activiti-event-timer-missing-configuration", process, (BaseElement)event, "Timer needs configuration (either timeDate, timeCycle or timeDuration is needed)");
        }
    }

    protected void handleCompensationEventDefinition(BpmnModel bpmnModel, Process process, Event event, EventDefinition eventDefinition, List<ValidationError> errors) {
        CompensateEventDefinition compensateEventDefinition = (CompensateEventDefinition)eventDefinition;
        if (StringUtils.isNotEmpty((CharSequence)compensateEventDefinition.getActivityRef()) && process.getFlowElement(compensateEventDefinition.getActivityRef(), true) == null) {
            this.addError(errors, "activiti-compensate-event-invalid-activity-ref", process, (BaseElement)event, "Invalid attribute value for 'activityRef': no activity with the given id");
        }
    }
}

