/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.impl.delegate.invocation.DefaultDelegateInterceptor;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.DelegateInterceptor;
import org.activiti.runtime.api.connector.DefaultServiceTaskBehavior;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.VariablesMappingProvider;
import org.activiti.spring.process.ProcessExtensionService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConnectorsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ExpressionManager expressionManager() {
        return new ExpressionManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExpressionResolver expressionResolver(ExpressionManager expressionManager, ObjectMapper objectMapper) {
        return new ExpressionResolver(expressionManager, objectMapper, (DelegateInterceptor)new DefaultDelegateInterceptor());
    }

    @Bean
    @ConditionalOnMissingBean
    public IntegrationContextBuilder integrationContextBuilder(VariablesMappingProvider variablesMappingProvider) {
        return new IntegrationContextBuilder(variablesMappingProvider);
    }

    @Bean(name={"defaultServiceTaskBehavior"})
    @ConditionalOnMissingBean(name={"defaultServiceTaskBehavior"})
    public DefaultServiceTaskBehavior defaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder, VariablesMappingProvider outboundVariablesProvider) {
        return new DefaultServiceTaskBehavior(applicationContext, integrationContextBuilder, outboundVariablesProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public VariablesMappingProvider variablesMappingProvider(ProcessExtensionService processExtensionService, ExpressionResolver expressionResolver) {
        return new VariablesMappingProvider(processExtensionService, expressionResolver);
    }
}

