/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.runtime.api.impl.MappingExecutionContext;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.ConstantDefinition;
import org.activiti.spring.process.model.Mapping;
import org.activiti.spring.process.model.ProcessConstantsMapping;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.VariableDefinition;

public class VariablesMappingProvider {
    private ProcessExtensionService processExtensionService;

    public VariablesMappingProvider(ProcessExtensionService processExtensionService) {
        this.processExtensionService = processExtensionService;
    }

    protected Optional<Object> calculateMappedValue(Mapping inputMapping, DelegateExecution execution, ProcessExtensionModel extensions) {
        if (inputMapping != null) {
            if (Mapping.SourceMappingType.VALUE.equals((Object)inputMapping.getType())) {
                return Optional.of(inputMapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)inputMapping.getType())) {
                String name = inputMapping.getValue().toString();
                VariableDefinition processVariableDefinition = extensions.getExtensions().getPropertyByName(name);
                if (processVariableDefinition != null) {
                    return Optional.ofNullable(execution.getVariable(processVariableDefinition.getName()));
                }
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateInputVariables(DelegateExecution execution) {
        ProcessExtensionModel extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        Map<String, Object> constants = this.calculateConstants(execution, extensions);
        if (extensions.getExtensions().hasEmptyInputsMapping(execution.getCurrentActivityId())) {
            return constants;
        }
        Map<String, Object> inboudVariables = !extensions.getExtensions().hasMapping(execution.getCurrentActivityId()) ? execution.getVariables() : this.calculateInputVariables(execution, extensions);
        inboudVariables.putAll(constants);
        return inboudVariables;
    }

    private Map<String, Object> calculateConstants(DelegateExecution execution, ProcessExtensionModel extensions) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        ProcessConstantsMapping processConstantsMapping = extensions.getExtensions().getConstantForFlowElement(execution.getCurrentActivityId());
        for (Map.Entry mapping : processConstantsMapping.entrySet()) {
            constants.put((String)mapping.getKey(), ((ConstantDefinition)mapping.getValue()).getValue());
        }
        return constants;
    }

    private Map<String, Object> calculateInputVariables(DelegateExecution execution, ProcessExtensionModel extensions) {
        HashMap<String, Object> inboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getExtensions().getMappingForFlowElement(execution.getCurrentActivityId());
        Map inputMappings = processVariablesMapping.getInputs();
        for (Map.Entry mapping : inputMappings.entrySet()) {
            Optional<Object> mappedValue = this.calculateMappedValue((Mapping)mapping.getValue(), execution, extensions);
            mappedValue.ifPresent(value -> inboundVariables.put((String)mapping.getKey(), value));
        }
        return inboundVariables;
    }

    private Optional<Object> calculateOutPutMappedValue(Mapping mapping, Map<String, Object> currentContextVariables) {
        if (mapping != null) {
            if (Mapping.SourceMappingType.VALUE.equals((Object)mapping.getType())) {
                return Optional.of(mapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)mapping.getType())) {
                String name = mapping.getValue().toString();
                return currentContextVariables != null ? Optional.ofNullable(currentContextVariables.get(name)) : Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateOutPutVariables(MappingExecutionContext execution, Map<String, Object> availableVariables) {
        ProcessExtensionModel extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        if (extensions.getExtensions().hasEmptyOutputsMapping(execution.getActivityId())) {
            return Collections.emptyMap();
        }
        if (!extensions.getExtensions().hasMapping(execution.getActivityId())) {
            return new HashMap<String, Object>(availableVariables);
        }
        if (!availableVariables.isEmpty()) {
            return this.calculateOutPutVariables(execution, extensions, availableVariables);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> calculateOutPutVariables(MappingExecutionContext execution, ProcessExtensionModel extensions, Map<String, Object> availableVariables) {
        HashMap<String, Object> outboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getExtensions().getMappingForFlowElement(execution.getActivityId());
        Map outputMappings = processVariablesMapping.getOutputs();
        for (Map.Entry mapping : outputMappings.entrySet()) {
            String name = (String)mapping.getKey();
            VariableDefinition processVariableDefinition = extensions.getExtensions().getPropertyByName(name);
            if (processVariableDefinition == null || !this.calculateOutPutMappedValue((Mapping)mapping.getValue(), availableVariables).isPresent()) continue;
            outboundVariables.put(name, this.calculateOutPutMappedValue((Mapping)mapping.getValue(), availableVariables).get());
        }
        return outboundVariables;
    }
}

