/*
 * Decompiled with CFR 0.152.
 */
package act.view.velocity;

import act.app.App;
import act.view.Template;
import act.view.View;
import act.view.velocity.ActResourceLoader;
import act.view.velocity.VelocityTemplate;
import act.view.velocity.VelocityTemplateException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public class VelocityView
extends View {
    public static final Version VERSION = Version.get();
    public static final String ID = "velocity";
    private VelocityEngine engine;
    private VelocityEngine stringEngine;
    private ResourceManager resourceManager;
    private String suffix;

    public String name() {
        return ID;
    }

    protected Template loadTemplate(String resourcePath) {
        try {
            org.apache.velocity.Template template = this.engine.getTemplate(resourcePath);
            return new VelocityTemplate(template);
        }
        catch (ResourceNotFoundException e) {
            if (resourcePath.endsWith(this.suffix)) {
                return null;
            }
            return this.loadTemplate(S.concat((String)resourcePath, (String)this.suffix));
        }
        catch (VelocityException e) {
            throw new VelocityTemplateException(e);
        }
    }

    protected Template loadInlineTemplate(String s) {
        this.stringResourceRepository().putStringResource(s, s);
        org.apache.velocity.Template template = this.stringEngine.getTemplate(s);
        return new VelocityTemplate(template);
    }

    private StringResourceRepository stringResourceRepository() {
        return (StringResourceRepository)this.stringEngine.getApplicationAttribute((Object)StringResourceLoader.REPOSITORY_NAME_DEFAULT);
    }

    protected void init(App app) {
        this.engine = new VelocityEngine();
        this.engine.init(this.conf(app));
        this.suffix = (String)app.config().get("view.velocity.suffix");
        this.suffix = null == this.suffix ? ".vm" : (this.suffix.startsWith(".") ? this.suffix : S.concat((String)".", (String)this.suffix));
        this.initStringEngine();
    }

    private void initStringEngine() {
        this.stringEngine = new VelocityEngine();
        this.stringEngine.setProperty("resource.loader", (Object)"string");
        this.stringEngine.addProperty("string.resource.loader.class", (Object)StringResourceLoader.class.getName());
        this.stringEngine.addProperty("string.resource.loader.repository.static", (Object)"false");
        this.stringEngine.init();
    }

    public List<String> loadContent(String template) {
        if (null == this.resourceManager) {
            try {
                Field fieldRi = VelocityEngine.class.getDeclaredField("ri");
                fieldRi.setAccessible(true);
                RuntimeInstance ri = (RuntimeInstance)fieldRi.get(this.engine);
                Field field = RuntimeInstance.class.getDeclaredField("resourceManager");
                field.setAccessible(true);
                this.resourceManager = (ResourceManager)field.get(ri);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
        try {
            Method method = ResourceManagerImpl.class.getDeclaredMethod("getLoaderForResource", String.class);
            method.setAccessible(true);
            ResourceLoader resourceLoader = (ResourceLoader)$.invokeVirtual((Object)this.resourceManager, (Method)method, (Object[])new Object[]{template});
            return IO.readLines((InputStream)resourceLoader.getResourceStream(template));
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
    }

    private Properties conf(App app) {
        Properties p = new Properties();
        p.setProperty("resource.loader", "file,class");
        p.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
        p.setProperty("file.resource.loader.path", this.templateRootDir().getAbsolutePath());
        p.setProperty("file.resource.loader.cache", app.isDev() ? "false" : "true");
        p.setProperty("file.resource.loader.modificationCheckInterval", "0");
        p.setProperty("class.resource.loader.class", ActResourceLoader.class.getName());
        p.setProperty("class.resource.loader.path", this.templateHome());
        return p;
    }
}

