/*
 * Decompiled with CFR 0.152.
 */
package act.view.velocity;

import act.Act;
import act.app.SourceInfo;
import act.view.TemplateException;
import act.view.velocity.VelocityView;
import java.util.List;
import org.apache.velocity.exception.ExtendedParseException;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.VelocityException;
import org.osgl.util.C;
import org.osgl.util.E;

public class VelocityTemplateException
extends TemplateException {
    private VelocityException velocityException;

    public VelocityTemplateException(VelocityException t) {
        super((Exception)t);
        this.velocityException = t;
    }

    public String errorMessage() {
        Throwable t = VelocityTemplateException.rootCauseOf((Throwable)((Object)this));
        return t.toString();
    }

    protected void populateSourceInfo(Throwable t) {
        if (t instanceof MethodInvocationException) {
            this.sourceInfo = VelocityTemplateException.getJavaSourceInfo((Throwable)t.getCause());
        }
        if (t instanceof ParseErrorException) {
            this.templateInfo = new VelocitySourceInfo((ParseErrorException)t);
        } else if (t instanceof ExtendedParseException) {
            this.templateInfo = new VelocitySourceInfo((ExtendedParseException)t);
        } else {
            throw E.unexpected((String)"Unknown exception type: %s", (Object[])new Object[]{t.getClass()});
        }
    }

    public List<String> stackTrace() {
        if (!(this.velocityException instanceof MethodInvocationException)) {
            return C.list();
        }
        return super.stackTrace();
    }

    protected boolean isTemplateEngineInvokeLine(String s) {
        return s.contains("freemarker.ext.beans.BeansWrapper.invokeMethod");
    }

    private static class VelocitySourceInfo
    extends SourceInfo.Base {
        VelocitySourceInfo(ParseErrorException e) {
            this.lineNumber = e.getLineNumber();
            this.fileName = e.getTemplateName();
            this.lines = VelocitySourceInfo.readTemplateSource(this.fileName);
        }

        VelocitySourceInfo(ExtendedParseException e) {
            this.lineNumber = e.getLineNumber();
            this.fileName = e.getTemplateName();
            this.lines = VelocitySourceInfo.readTemplateSource(this.fileName);
        }

        private static List<String> readTemplateSource(String template) {
            VelocityView view = (VelocityView)Act.viewManager().view("velocity");
            return view.loadContent(template);
        }
    }
}

